// UV Patch.js
//	this is Tool script, place it into ~/Library/Application Support/Cheetah3D/scripts/Tool folder
//

// add function to Array class.
if( !Array.indexOf) {
	Array.prototype.indexOf = function(str) {
		for(var i = 0; i < this.length; i++) {
			if(this[i] == str)
				return i;
		}
		return -1;
	}
}
if (!Array.isExists) {
	Array.prototype.isExists = function(value) {
		for (var i = 0;i < this.length;i++) {
			if (this[i] == value) {
				return true;
			}
		}
		return false;
	}
}
if (!Array.pushUniqueInfo) {
  Array.prototype.pushUniqueInfo = function(value) {
    var result = false;
    for (var i = 0;i < this.length;i++) {
      if (this[i].pid == value.pid && this[i].tid == value.tid) {
        result = i;
      }
    }

    if (result == false) return this.push( value );
    else return result;
  }
}

function buildUI(tool) {
	tool.addParameterSeparator("UV Patch");
	
	tool.addParameterLink("uv guide obj", false, false);
	tool.addParameterSelector("patch uvset", ["UV1", "UV2"], false, false);
	tool.addParameterSelector("patch mode", ["UV → UV", "XY → UV", "XZ → UV", "YZ → UV"], false, false);
	tool.addParameterSelector("patch burn uv", ["none", "UV1", "UV2"], false, false);
  tool.addParameterBool("patch guide mat", 1, 0, 1, false, false);
	tool.addParameterBool("patch target mat", 1, 0, 1, false, false);
	tool.addParameterFloat("patch offset", 0, -1000, 1000, false, false );
  tool.addParameterBool("patch as new obj", 1, 0, 1, false, false);
	tool.addParameterButton("patch mesh", "patch", "patchMeshWithUV");
	
	tool.addParameterSeparator("Mesh Creation");
	tool.addParameterSelector("create uvset", ["UV1", "UV2"], false, false);
	tool.addParameterBool("create connect", 1, 0, 1, false, false);
	tool.addParameterButton("create mesh","create","createMeshWithUV");
	
  //tool.setParameter("patch mode", 1)
}

function Vec2D_cross ( v1, v2 ) {
  return v1.x * v2.y - v1.y * v2.x;
}

function Vec2D_dot ( v1, v2 ) {
  return (v1.x * v2.x) + (v1.y * v2.y);
}

function Vec2D_length () {
  if (arguments.length > 1) {
    return Math.sqrt( Math.pow(arguments[0].x - arguments[1].x, 2) + Math.pow(arguments[0].y - arguments[1].y, 2) );
  } else {
    return Math.sqrt( Math.pow(arguments[0].x, 2) + Math.pow(arguments[0].y, 2) );
  }
}

function Vec2D_normalize ( v1 ) {
  if (v1.norm() == 0) return new Vec2D();
  return v1.multiply( 1 / v1.norm() );
}

function Vec2D_toString ( v1 ) {
  return v1.x.toFixed(4) + ', ' + v1.y.toFixed(4);
}

function Vec3D_normalize( v1 ) {
  if (v1.norm() == 0) return new Vec3D();
  return v1.multiply( 1 / v1.norm() );
}

function Vec3D_toString ( v1 ) {
  return v1.x.toFixed(4) + ', ' + v1.y.toFixed(4) + ', ' + v1.z.toFixed(4);
}

function Vec3D_length () {
  if (arguments.length > 1) {
    return Math.sqrt( Math.pow(arguments[0].x - arguments[1].x, 2) + Math.pow(arguments[0].y - arguments[1].y, 2) +  Math.pow(arguments[0].z - arguments[1].z, 2) );
  } else {
    return Math.sqrt( Math.pow(arguments[0].x, 2) + Math.pow(arguments[0].y, 2) + Math.pow(arguments[0].z, 2) );
  }
}



function patchMeshWithUV( tool ) {
  var guide = tool.getParameter("uv guide obj");
  var obj = tool.document().selectedObject();
  
  var asNew = tool.getParameter("patch as new obj");

  if (!guide || guide.family() != NGONFAMILY || !obj || obj.family() != NGONFAMILY || (asNew == false && obj.type() != POLYGONOBJ) ) return;
  
  var uvset = tool.getParameter("patch uvset");
  var offset = tool.getParameter("patch offset");
  var mode = tool.getParameter("patch mode");
  var burn = tool.getParameter("patch burn uv");
  var guideMat = tool.getParameter("patch guide mat");
  var targetMat = tool.getParameter("patch target mat");
  
  if (guideMat) {
    var guideMat = guide.obj2WorldMatrix();
  } else {
    var guideMat = new Mat4D(TRANSLATE, 0, 0, 0);
  }

  if (targetMat) {
    var objMat = obj.obj2WorldMatrix();
  } else {
    var objMat = new Mat4D(TRANSLATE, 0, 0, 0);
  }
  var objMatInv = objMat.inverse();
  
  var guideCore = guide.modCore();
  var core = (asNew)? obj.modCore() : obj.core();
  
  var t1 = new Date();
  var tc = 0;
  
  var i, j;
  var ii, jj;
  var moved = [];
  var polygonCount = core.polygonCount();
  var guidePolygonCount = guideCore.polygonCount();
  var guideTriCount = guideCore.triangleCount();
  
  print( '-- UV Patch.js' );
  print( 'polys: ' + polygonCount.toString().replace(/([0-9]+?)(?=(?:[0-9]{3})+$)/g , '$1,') + ', guideTris: ' + guideTriCount.toString().replace(/([0-9]+?)(?=(?:[0-9]{3})+$)/g , '$1,') + ', calcMax: ' + ( polygonCount * guideTriCount ).toString().replace(/([0-9]+?)(?=(?:[0-9]{3})+$)/g , '$1,') );
  
  obj.recordGeometryForUndo();
  
  var vertexCount = core.vertexCount();

  /*
  var bbMin = objMat.multiply( core.vertex(0) );
  var bbMax = objMat.multiply( core.vertex(0) );
  
  for(i = 1;i < vertexCount;i++) {
    var bb = objMat.multiply( core.vertex(i) );
    
    bbMin.x = (bb.x < bbMin.x)? bb.x : bbMin.x;
    bbMin.y = (bb.y < bbMin.y)? bb.y : bbMin.y;
    bbMin.z = (bb.z < bbMin.z)? bb.z : bbMin.z;
    bbMax.x = (bb.x > bbMax.x)? bb.x : bbMax.x;
    bbMax.y = (bb.y > bbMax.y)? bb.y : bbMax.y;
    bbMax.z = (bb.z > bbMax.z)? bb.z : bbMax.z;
  }
  
  print( 'bounding-box min:' + Vec3D_toString( bbMin ) + ', max:' + Vec3D_toString( bbMax ) );
   */

  if (burn > 0) {
    var vertInfo = {};
    
    for (i = 0;i < vertexCount;i++) {
      vertInfo[i] = [];
    }
    
    for (i = 0;i < polygonCount;i++) {
      var polygonSize = core.polygonSize( i );
      for (j = 0;j < polygonSize;j++) {
        var vertexIndex = core.vertexIndex( i, j );
        
        vertInfo[ vertexIndex ].push( [ i, j ] );
      }
    }
  }
  
  if (asNew) {
    var newObj = tool.document().addObject(POLYGONOBJ);
    var newCore = newObj.core();

    newObj.setParameter("name", obj.getParameter("name")+'_patched');
    tool.document().root().addChildAtIndex( newObj, tool.document().root().childCount() );

    for (i = 0;i < vertexCount;i++) {
      newCore.addVertex( false, objMat.multiply( core.vertex(i) ) );
    }

    for (i = 0;i < polygonCount;i++) {
      var polygonSize = core.polygonSize(i);
      var vertices = [];

      for (j = 0;j < polygonSize;j++) {
        vertices.push( core.vertexIndex(i, j ));
      }

      var pid = newCore.addIndexPolygon( polygonSize, vertices );

      for (j = 0;j < polygonSize;j++) {
        newCore.setUVCoord( pid, j, core.uvCoord( i, j ));
      }
    }

    obj = newObj;
    core = newCore;
    
    obj.update();

    objMat = new Mat4D(TRANSLATE, 0, 0, 0);
    objMatInv = objMat.inverse();

    print('create new object as ' + obj.getParameter("name"));
  }

  // cache guidePolygon info tree

  var guideInfo = [];
  var section = Math.ceil( guideTriCount / 200 );

  if (section > 16) section = 16;
  for (i = 0;i < section;i++) {
    guideInfo[i] = [];
    for (j = 0;j < section;j++) {
      guideInfo[i][j] = [];
    }
  }
  print( 'search tree creating... section(s): ' + section );

  var uvLabels = [ 'uvA', 'uvB', 'uvC' ];

  for (i = 0;i < guidePolygonCount;i++) {
    var guidePolygonSize = guideCore.polygonSize( i );
    var normal = guideCore.normal( i );
    for (j = 0;j < guidePolygonSize - 2;j++) {
      var info = {};

      var tris = guideCore.triangle( i, j );
      
      info.pid = i;
      info.tid = j;
      info.tr0 = tris[0];
      info.tr1 = tris[1];
      info.tr2 = tris[2];
      info.normal = normal;

      for (ii = 0;ii < 3;ii++) {
        var uv = guideCore.uvCoord( i, tris[ii] );
        info[ uvLabels[ii] ] = (uvset == 0)? new Vec2D( uv.x, uv.y ) : new Vec2D( uv.z, uv.w );
      }

      for (ii = 0;ii < 3;ii++) {
        var ix = 0;
        var iy = 0;
        var uv = info[ uvLabels[ii] ];

        for (si = 0;si < section;si++) {
          if (uv.x >= si * (1/section) && uv.x <= (si + 1) * (1/section)) {
            ix = si;
          }
          for (sj = 0;sj < section;sj++) {
            if (uv.y >= sj * (1/section) && uv.y <= (sj + 1) * (1/section)) {
              iy = sj;
            }
          }
        }

        guideInfo[ ix ][ iy ].pushUniqueInfo( info );
      }
    }
  }
  print( '        done.' );

  var error_fac = 0.000001;

  for (i = 0;i < polygonCount;i++) {
    var polygonSize = core.polygonSize( i );
    for (j = 0;j < polygonSize;j++) {
      
      var vertexIndex = core.vertexIndex( i, j );
      var matches = [];

      if (moved.indexOf( vertexIndex ) === -1) {
        switch( mode ) {
          case 0:
            var uv4d = core.uvCoord( i, j );
            var uvP = (uvset == 0)? new Vec2D( uv4d.x, uv4d.y ) : new Vec2D( uv4d.z, uv4d.w );
            var h = 0;
            break;
          case 1:
            var uvVec = objMat.multiply( core.vertex( core.vertexIndex( i, j ) ) );
            var uvP = new Vec2D( uvVec.x, uvVec.y * -1 );
            var h = uvVec.z;
            break;
          case 2:
            var uvVec = objMat.multiply( core.vertex( core.vertexIndex( i, j ) ) );
            var uvP = new Vec2D( uvVec.x, uvVec.z );
            var h = uvVec.y;
            break;
          case 3:
            var uvVec = objMat.multiply( core.vertex( core.vertexIndex( i, j ) ) );
            var uvP = new Vec2D( uvVec.y * -1, uvVec.z );
            var h = uvVec.x;
            break;
        }
        
        var flg = false;
        
        var error = '';

        error += uvP.x.toFixed(3) + ', ' + uvP.y.toFixed(3) + "\n";
        
        if ((new Date() - t1) > tc) {
          print( 'progress:' + (i / polygonCount * 100).toFixed(2) + '%' );
          tc = new Date() - t1 + 500;
        }
        

        var ix = 0;
        var iy = 0;
        for (var si = 0;si < section;si++) {
          if (uvP.x >= si * (1/section) && uvP.x <= (si + 1) * (1/section)) {
            ix = si;
            si = section;
          }
          for (var sj = 0;sj < section;sj++) {
            if (uvP.y >= sj * (1/section) && uvP.y <= (sj + 1) * (1/section)) {
              iy = sj;
              sj = section;
            }
          }
        }

        var guideInfo_sec = [];

        Array.prototype.push.apply( guideInfo_sec, guideInfo[ix][iy] );

        if (ix > 0) {
          Array.prototype.push.apply( guideInfo_sec, guideInfo[ix-1][iy] );
          if (iy > 0) Array.prototype.push.apply( guideInfo_sec, guideInfo[ix-1][iy-1] );
          if (iy < section - 1) Array.prototype.push.apply( guideInfo_sec, guideInfo[ix-1][iy+1] );
        }
        if (ix < section - 1) {
          Array.prototype.push.apply( guideInfo_sec, guideInfo[ix+1][iy] );
          if (iy > 0) Array.prototype.push.apply( guideInfo_sec, guideInfo[ix+1][iy-1] );
          if (iy < section - 1) Array.prototype.push.apply( guideInfo_sec, guideInfo[ix+1][iy+1] );
        }
        if (iy > 0) Array.prototype.push.apply( guideInfo_sec, guideInfo[ix][iy-1] );
        if (iy < section - 1) Array.prototype.push.apply( guideInfo_sec, guideInfo[ix][iy+1] );


        var guideInfo_sec_len = guideInfo_sec.length; 
        // detection guide polygon that contains target point.
        for (ii = 0;ii < guideInfo_sec_len;ii++) {
          var info = guideInfo_sec[ii];

          var uvA = info.uvA;
          var uvB = info.uvB;
          var uvC = info.uvC;
          
          var AB = uvB.sub( uvA );
          var BP = uvP.sub( uvB );
          var c1 = Vec2D_cross( AB, BP );
          
          var BC = uvC.sub( uvB );
          var CP = uvP.sub( uvC );
          var c2 = Vec2D_cross( BC, CP );
          
          var CA = uvA.sub( uvC );
          var AP = uvP.sub( uvA );
          var c3 = Vec2D_cross( CA, AP );
            
          if (Math.abs( c1 ) < error_fac) c1 = 0;
          if (Math.abs( c2 ) < error_fac) c2 = 0;
          if (Math.abs( c3 ) < error_fac) c3 = 0;
          
          if ((c1 >= 0 && c2 >= 0 && c3 >= 0) || (c1 <= 0 && c2 <= 0 && c3 <= 0)) {
            
            var normal = info.normal;
            
            var rad2deg = 180 / Math.PI;
            
            var AC = uvC.sub( uvA );
            
            var APn = Vec2D_normalize( AP );
            var BCn = Vec2D_normalize( BC );
            
            var work1 = Vec2D_dot( APn, BCn );
            var work2 = 1 - work1 * work1;
            
            var d = (Vec2D_dot( CA, APn ) - work1 * Vec2D_dot( CA, BCn )) / work2;
            var AD = APn.multiply( d );
            var uvD = uvA.sub( AD );
            
            lenBC = Vec2D_length( uvB, uvC );

            if (lenBC == 0) {
              var ratioBD = 0;
            } else {
              var ratioBD = Vec2D_length( uvB, uvD ) / lenBC;
            }

            var lenAP = Vec2D_length( AP );
            var lenAD = Vec2D_length( AD );
            
            if (lenAD == 0) {
              var ratioAP = 0;
            } else {
              var ratioAP = lenAP / lenAD;
            }

            var vecA = guideMat.multiply( guideCore.vertex( guideCore.vertexIndex( info.pid, info.tr0 ) ) ); // A
            var vecB = guideMat.multiply( guideCore.vertex( guideCore.vertexIndex( info.pid, info.tr1 ) ) ); // B
            var vecC = guideMat.multiply( guideCore.vertex( guideCore.vertexIndex( info.pid, info.tr2 ) ) ); // C
            
            var vecAC = vecC.sub( vecA );
            var vecAB = vecB.sub( vecA );
            var vecBC = vecC.sub( vecB );
            
            var vecD = vecB.add( vecBC.multiply( ratioBD ) );
            
            var vecAD = vecD.sub( vecA );
            
            var vec = vecA.add( vecAD.multiply( ratioAP ) );
            
            if (c1 == 0 || c2 == 0 || c3 == 0) {
              //print( vertexIndex + ': ' + c1.toFixed(4) + ', ' + c2.toFixed(4) + ', ' + c3.toFixed(4) );
              
              matches.push( [ vec, normal ] );
              
            } else {
              var normalOffset = normal.multiply( offset + h );

              flg = true;
              
              vec = vec.add( normalOffset );
              
              core.setVertex( vertexIndex, objMatInv.multiply( vec ) );
              
              // set uvcoord
              if (mode > 0 && burn > 0) {
                for (var jj = 0;jj < vertInfo[vertexIndex].length;jj++) {
                  var info = vertInfo[vertexIndex][jj];
                  var uv = core.uvCoord( info[0], info[1] );
                  
                  if (burn == 1) {
                    uv.x = uvP.x;
                    uv.y = uvP.y;
                  } else {
                    uv.z = uvP.x;
                    uv.w = uvP.y;
                  }
                  core.setUVCoord( info[0], info[1], uv );
                }
              }
              
              moved.push( vertexIndex );
              
              // exit detection loop
              //print( vertexIndex + ':' + ii);
              ii = guideInfo_sec_len; 
            }
          }
        }
      }
      
      if (matches.length > 0) {
        vec = matches[0][0];
        normal = matches[0][1];
        
        for (var mi = 1;mi < matches.length;mi++) {
          normal = normal.add( matches[mi][1] );
        }
        
        normal = normal.multiply( 1 / matches.length );
        
        var normalOffset = normal.multiply( offset + h );

        vec = vec.add( normalOffset );
        
        core.setVertex( vertexIndex, objMatInv.multiply( vec ) );
        
        // set uvcoord
        if (mode > 0 && burn > 0) {
          for (var ii = 0;ii < vertInfo[vertexIndex].length;ii++) {
            var info = vertInfo[vertexIndex][ii];
            var uv = core.uvCoord( info[0], info[1] );
            
            if (burn == 1) {
              uv.x = uvP.x;
              uv.y = uvP.y;
            } else {
              uv.z = uvP.x;
              uv.w = uvP.y;
            }
            core.setUVCoord( info[0], info[1], uv );
          }
        }
        
        //print( vertexIndex + ':' + ii + ', multiple');
        moved.push( vertexIndex );
        flg = true;
      }

      if (!flg) {
        print( 'unmatch: ' + j + '/' + i + ' [' + vertexIndex + '], tree: ' + ix + ', ' + iy );
        print( section );
        print( error );
        core.setVertexSelection( vertexIndex, true );
      }
    }
  }
  
  obj.update();
  
  var t3 = new Date();
  print( "\n" + 'patched: ' + ((t3 - t1) / 1000).toFixed(2) + ' s' + "\n");
}

function createMeshWithUV( tool ) {
  var obj = tool.document().selectedObject();
  
  if (!obj || obj.family() != NGONFAMILY) return;
  
  var uvset = tool.getParameter("create uvset");
  var connect = (tool.getParameter("create connect") == 1)? true : false;
  var i,j;
  var core = obj.core();
  var polygonCount = core.polygonCount();
  
  var newObj = tool.document().addObject( POLYGONOBJ );
  var newCore = newObj.core();
  
  newObj.setParameter("name", obj.getParameter("name") + '_UV' );
  
  for (i = 0;i < polygonCount;i++) {
    var polygonSize = core.polygonSize(i);
    
    var vecList = [];
    var uvList = [];
    for (j = 0;j < polygonSize;j++) {
      var info = core.uvCoord( i, j );
      //var vec = (uvset == 0)? new Vec3D( info.x - 0.5, info.y * -1 + 0.5, 0 ) : new Vec3D( info.z - 0.5, info.w * -1 + 0.5, 0 );
      var vec = (uvset == 0)? new Vec3D( info.x, info.y * -1, 0 ) : new Vec3D( info.z, info.w * -1, 0 );
      
      vecList.push( vec );
      uvList.push( info );
    }
    
    newCore.addPolygon( polygonSize, connect, vecList, uvList );
  }
  
  newObj.update();
}

/* helper functions for debugging

 */
 
function setParameterForName( tool, name, param, val ) {
  var root = tool.document().root();
  
  var obj = objectWithName( root, name );
  
  if (obj !== null) {
    obj.setParameter(param, val);
  }
}

function objectWithName( obj, name ) {
  var result = null;
  var childCount = obj.childCount();
  for( var i = 0;i < childCount;i++) {
    var child = obj.childAtIndex( i );
    if  ( child.getParameter("name") == name) {
      result = child;
    }
    if (result === null) {
      result = objectWithName( child, name );
    }
  }
  return result;
}
